from pymongo import MongoClient
import matplotlib.pyplot as plt
from matplotlib.font_manager import *
import matplotlib

# 设置可视化组件类型
matplotlib.use('TkAgg')

# 连接 MongoDB 数据库
client = MongoClient('127.0.0.1', 27017)
db = client.get_database("lianjia")
col = db.get_collection("loupan")

# 设置 match 和 group 分组聚合管道得到城市每个区域住房的房价信息
print("-" * 20)
# 过滤掉房价待定且不是住宅用途的楼盘
pipeline = [

    {"$match":
        {
            "type": "住宅",
            "price": {"$ne": 0}
        }
    },
    {"$group":
        {
            "_id": "$area",
            "avgPrice": {"$avg": "$price"},
            "MaxPrice": {"$max": "$price"}
        }
    },
]
data = col.aggregate(pipeline)
for item in data:
    print(item)
print("-" * 20)

# 进行聚合计算操作
lists = col.aggregate(pipeline)
label_list = []
num_list1 = []
num_list2 = []

# 获取聚合后的数据并插入label_list ，num_list1，num_list2，用于纵横坐标显示。
for list in lists:
    label_list.append(list['_id'])
    num_list1.append(round(list['avgPrice'], 1))
    num_list2.append(list['MaxPrice'])

# 设置中文字体和负号正常显示

myfont = FontProperties(fname='/usr/share/fonts/truetype/wqy/wqy-zenhei.ttc')  # 解决中文乱码

matplotlib.rcParams['axes.unicode_minus'] = False  # 解决正负号问题

x = range(len(num_list1))

# 绘制条形图 :条形中点横坐标；height:长条形高度；width:长条形宽度，默认值0.8；label:为后面设置 legend 准备
rects1 = plt.bar(x, height=num_list1, width=0.4, alpha=0.8, color='red', label="average")
rects2 = plt.bar([i + 0.4 for i in x], height=num_list2, width=0.4, color='green', label="highest")
plt.ylim(0, max(num_list2) + 1000)  # y 轴取值范围
plt.ylabel(u"价格", fontproperties=myfont)

# 设置 x 轴刻度显示值；参数一：中点坐标；参数二：显示值
plt.xticks([index + 0.2 for index in x], label_list, fontproperties=myfont)
plt.xlabel(u"区域", fontproperties=myfont)
plt.title(u"武汉地区房价", fontproperties=myfont)
plt.legend()  # 设置题注

for rect in rects1:
    height = rect.get_height()
    plt.text(rect.get_x() + rect.get_width() / 2, height + 1, str(height), ha="center", va="bottom",
             fontproperties=myfont)
for rect in rects2:
    height = rect.get_height()
    plt.text(rect.get_x() + rect.get_width() / 2, height + 1, str(height), ha="center", va="bottom",
             fontproperties=myfont)
# 显示条形图
plt.show()
# 关闭数据库连接
client.close()
